#include "lg_gba.h"
#include "lg_sprite.h"
#include "lg_sincos.h"

void IWRAM_CODE MoveSprite(OAMEntry* whatSprite, int x, int y)
{
	if( x > 240) x = 240;
	if( y > 160) y = 160;
	if( x < -64) x = 240;
	if( y < -64) y = 160;

	if(x < 0 && x > -64) x = 512 + x;
	if(y < 0 && y > -64) y = 256 + y;

	whatSprite->attribute1 = (whatSprite->attribute1 & 0xFE00)| x;

	whatSprite->attribute0 = (whatSprite->attribute0 & 0xFF00)| y;
}

void IWRAM_CODE RotateSprite(int rotDataIndex, int angle, s32 x_scale, s32 y_scale)
{
	int spr = rotDataIndex<<2;
	s32 pa,pb,pc,pd;

	pa = ((x_scale) * GetCos(angle))>>8;
	pb = ((y_scale) * GetSin(angle))>>8;
	pc = ((x_scale) * -GetSin(angle))>>8;
	pd = ((y_scale) * GetCos(angle))>>8;

	sprites[spr].attribute3 = (u16)pa;
	sprites[spr+1].attribute3 = (u16)pb;
	sprites[spr+2].attribute3 = (u16)pc;
	sprites[spr+3].attribute3 = (u16)pd;
}












